#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <iostream>

using namespace std;

int numvec (int length, int *vec1, int *vec2)
//  computes in how many components two 
//  vectors coincide
  {
	int i;
	int numeq=0; 

  for (i=0; i<length; i++)
    {
		if (vec1[i] == vec2[i])
		  numeq++;
		}

	return numeq;
	}

int eqvec (int length, int *vec)
//  computes whether a vector is equal in at least
//  two components 
  {
	int s,t;
  int equal = 0;

	for (s=0; s<length; s++)
		for (t=s+1; t<length; t++)
			{
			if (vec[s] == vec[t])
				{
				equal = 1;
				return equal;
				}
			}

	return equal;
	}

bool strategy_check (int c, int p, int questions, int **strategy)
// checks the feasibility of a strategy 	
	{
	int i,j,l,r,s,t;

	int iaux;
	bool optstrat;
	int numsec;
	int numsec2;
  int counter;

	int *auxvec;

	int **answermat;
	int **pmat;

	iaux = 1;
	for (s=0; s<p; s++)
		iaux *= (c-s);
	numsec = iaux;

	auxvec = (int*) malloc(sizeof(int) * p);

  answermat = (int**) malloc(sizeof(int*) * numsec);
  pmat = (int**) malloc(sizeof(int*) * numsec);

  for (s=0; s<numsec; s++)
	  answermat[s] = (int*) malloc(sizeof(int) * questions);

  for (s=0; s<numsec; s++)
	  pmat[s] = (int*) malloc(sizeof(int) * p);

  optstrat = 1;

	counter = 0;
	numsec2 = (int) floor(pow(c,p)+0.5);


	for (s=0; s<numsec2; s++)
		{
		for (j=0; j<p; j++)
			auxvec[j] = 0;

		iaux = s;
		j=p-1;
		while (j>=0)
			{
			auxvec[j] = iaux % c;
			iaux /= c;
			j--;
			}

		if (eqvec(p,auxvec))
			continue;

		for (j=0; j<p; j++)
			pmat[counter][j] = auxvec[j];

		for (i=0; i<questions; i++)
			answermat[counter][i] = numvec(p, strategy[i], pmat[counter]);

    counter++;
		}


	for (s=0; s<numsec; s++)
    {
		for (t=s+1; t<numsec; t++)
      {
			if (numvec(questions,answermat[s],answermat[t]) == questions)
				{
				optstrat = 0;
			  }
			}
    }

   
  free (auxvec);

  for (s=0; s<numsec; s++)
	   free (answermat[s]);
	free (answermat);

  for (s=0; s<numsec; s++)
	   free (pmat[s]);
	free (pmat);

	return optstrat;
  }

int main (int argc, char **argv)
  {
	int i,j,l;
	int s,t;
	int start;
	int c;
	int filexist;
	int equal;
	int optstrat;
	int p;
	int questions;
	int **strategy;
	char* ep;
  char* filename;
  FILE *fname;

	c = 3;
	filexist = 0;
	p = 3;
	questions = 3;

  filename = (char*) malloc(sizeof(char) * 100);

  for (start = 1; start < argc; start++)
		{    
		if (*argv[start] == '-') 
			{    
			char *ep; 
			char *sc = argv[start] + 1; 
			
			while (*sc)
				{
				switch (*sc++)
				  {
					case 'c': 
					  c = strtoul(sc, &ep, 10); 
					  if (ep > sc)
							sc = ep; 
					break;
					case 'p': 
					  p = strtoul(sc, &ep, 10); 
					  if (ep > sc)
							sc = ep; 
					break;
					case 'q': 
					  questions = strtoul(sc, &ep, 10); 
					  if (ep > sc)
							sc = ep; 
					break;
          }
				}
			}
		else
			{
      filexist = 1;
			strcpy (filename,argv[start]);
		  }
		}	


	if (filexist == 1)
	  {
		if (fname = fopen (filename,"r"))
			{
			}
		else
			{
			cout << "Error1" << endl;
			cout << "File ``" << filename << "`` kann nicht geoeffnet werden!" << endl;
			exit(1);
			}
		}	

	if (p > c)
		{
		cout << "Error2" << endl;
		cout << "p = " << p << " is larger than " << "c = " << c << " in AB Game." << endl;
		exit(1);
		}

  strategy = (int**) malloc(sizeof(int*) * questions);

  for (i=0; i<questions; i++)
	  strategy[i] = (int*) malloc(sizeof(int) * p);

	for (i=0; i<questions; i++)
		{
		for (j=0; j<p; j++)
			{
			fscanf (fname,"%d \n", &strategy[i][j]);
			if (strategy[i][j] > c-1 || strategy[i][j] < 0)
				{
				cout << "Error5" << endl;
				cout << "In entry (" << i << ", " << j 
						 << ") there is the entry " 
						 << strategy[i][j] << "." << endl; 
				exit(1);
				}
			}
		}	
	fclose (fname);

for (i=0; i<questions; i++)
	{
	equal = eqvec (p,strategy[i]);
	if (equal == 1)
		{
		cout << "Error6" << endl;
		cout << "In the AB-Game there" 
				 << "are two equal entries in the " 
				 << i+1 << "-th question " << endl;
		exit(1);
		}
	}

  cout << "Strategy:" << endl;
  for (i=0; i<questions; i++)
	  {
	  for (j=0; j<p; j++)
		  cout << strategy[i][j] << " ";
	
   	cout << endl;
		}


	optstrat = strategy_check (c, p, questions, strategy);
	 
	if (optstrat == 1)
		cout << "Strategy is feasible." << endl;
	else
		cout << "Strategy is not feasible." << endl;

  for (i=0; i<questions; i++)
	   free (strategy[i]);
	free (strategy);

	free (filename);

	return 1;
	}

